/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.client.pi;

import com.ibm.hsc.cim.client.HSCCIMClient;
import com.ibm.hsc.client.PIHSCSysClient;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.exceptions.PIHscExceptionUtils;
import com.ibm.hsc.common.util.PIHscUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class PIHscSysCIMClient
extends HSCCIMClient
implements PIHSCSysClient {
    public static final String MOF_METHOD_SET_PASSWORD = "setPassword";
    public static final String MOF_METHOD_PLATFORM_PASSWORD = "platformPassword";
    public static final String MOF_PASSWORD_TO_UPDATE = "passwordToUpdate";
    public static final String MOF_CURRENT_PASSWORD = "currentPassword";
    public static final String MOF_NEW_PASSWORD = "newPassword";
    public static final String MOF_PASSWORD = "password";
    public static final String MOF_DUMP_TYPE = "dumpType";
    public static final String MOF_DUMP_SIDE = "side";
    public static final String MOF_FIRMWARE_CODE_SIDE = "FirmwareCodeSide";
    public static final String MOF_FSP_TARGET = "FSPTarget";
    public static final String MOF_FIRMWARE_UPDATE_SIDE = "UpdateSide";
    public static final String MOF_FIRMWARE_COMPONENT = "FirmCompToUpdate";
    public static final String MOF_LID_NUMBER = "LIDNumber";
    public static final String MOF_LID_FILENAME = "Filename";
    public static final String MOF_LID_OFFSET = "LIDOffset";
    public static final String MOF_COMPLETION_TYPE = "CompletionType";
    public static final String MOF_COMMIT_TYPE = "CommitType";
    public static final String MOF_CODE_UPDATE_OWNER = "CodeUpdateOwner";
    public static final String MOF_LENGTH_TO_READ = "LengthToRead";
    public static final String MOF_READ_LID_FILENAME = "LIDFileName";
    public static final String MOF_METHOD_REBOOTSP = "RebootServiceProcessor";
    public static final String MOF_METHOD_STARTCODEUPDATE = "StartCodeUpdate";
    public static final String MOF_METHOD_BEGINCODEUPDATE = "BeginCodeUpdateProcess";
    public static final String MOF_METHOD_ENDCODEUPDATE = "EndCodeUpdateProcess";
    public static final String MOF_METHOD_WRITELID = "WriteLID";
    public static final String MOF_METHOD_WRITELID_PARTIAL = "WriteLIDPartial";
    public static final String MOF_METHOD_CODEUPDATECOMPLETE = "CodeUpdateComplete";
    public static final String MOF_METHOD_COMMITCODEUPDATE = "CommitCodeUpdate";
    public static final String MOF_METHOD_DELETELID = "DeleteLID";
    public static final String MOF_METHOD_SETCODEUPDATEOWNER = "SetCodeUpdateOwner";
    public static final String MOF_METHOD_GETCODEUPDATEOWNER = "GetCodeUpdateStatus";
    public static final String MOF_METHOD_READLID = "ReadLID";
    public static final String MOF_METHOD_READLID_PARTIAL = "ReadLIDPartial";
    public static final String MOF_METHOD_READLID_SPECIAL = "ReadSpecialLID";
    public static final String MOF_METHOD_OPEN_PHYP_FILE = "OpenPhypFile";
    public static final String MOF_METHOD_WRITE_PHYP_FILE = "WritePhypFile";
    public static final String MOF_METHOD_CLOSE_PHYP_FILE = "ClosePhypFile";
    public static final String MOF_METHOD_GET_FIRMWARE_UPDATE_STATUS = "GetFirmwareUpdateStatus";
    public static final String MOF_METHOD_START_FIRMWARE_UPDATE = "StartFirmwareUpdate";
    public static final String MOF_SPECIAL_LID = "SpecialID";
    private int m_sysType;

    private PIHscSysCIMClient(String string, String string2, CIMObjectPath cIMObjectPath, String string3, int n) {
        super(string, null, string2, cIMObjectPath, string3);
        this.m_sysType = n;
    }

    public static PIHscSysCIMClient createInstance(String string, String string2, boolean bl, int n) throws PIHscClientException {
        return PIHscSysCIMClient.createInstance(string, string2, bl, "root/ibmhscS1_0", n);
    }

    public static PIHscSysCIMClient createInstance(String string, String string2, boolean bl, String string3, int n) throws PIHscClientException {
        try {
            String string4 = "CEC";
            if (1 == n) {
                string4 = "BPA";
            }
            CIMObjectPath cIMObjectPath = null;
            if (0 == n) {
                cIMObjectPath = new CIMObjectPath("IBMHSC_ComputerSystem", string3);
                cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
            } else if (1 == n) {
                cIMObjectPath = new CIMObjectPath("IBMHSC_Frame", string3);
                cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Frame"));
            }
            Enumeration enumeration = PIHscUtil.getCIMEnumInstances(string, cIMObjectPath, true);
            CIMObjectPath cIMObjectPath2 = null;
            CIMObjectPath cIMObjectPath3 = null;
            String string5 = null;
            while (enumeration != null && enumeration.hasMoreElements()) {
                CIMObjectPath cIMObjectPath4 = (CIMObjectPath)enumeration.nextElement();
                CIMValue cIMValue = null;
                if (0 == n) {
                    cIMValue = PIHscUtil.getCIMAttribute(string, cIMObjectPath4, "Name");
                } else if (1 == n) {
                    cIMValue = PIHscUtil.getCIMAttribute(string, cIMObjectPath4, "Name");
                }
                string5 = (String)cIMValue.getValue();
                if (string2.equals(string5)) {
                    cIMObjectPath3 = cIMObjectPath4;
                    if (bl) break;
                }
                if (bl) continue;
                if (0 == n) {
                    cIMValue = PIHscUtil.getCIMAttribute(string, cIMObjectPath4, "UserDefinedName");
                } else if (1 == n) {
                    cIMValue = PIHscUtil.getCIMAttribute(string, cIMObjectPath4, "UserDefinedName");
                }
                if (!string2.equals((String)cIMValue.getValue())) continue;
                cIMObjectPath2 = cIMObjectPath4;
                break;
            }
            if (cIMObjectPath2 == null && cIMObjectPath3 == null) {
                return null;
            }
            if (cIMObjectPath2 == null) {
                string5 = string2;
            } else {
                cIMObjectPath3 = cIMObjectPath2;
            }
            return new PIHscSysCIMClient(string, string5, cIMObjectPath3, string3, n);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    private void debug(String string) {
        System.err.println("| SysClient." + string);
    }

    public int getSysType() {
        this.debug("getSysType=" + this.m_sysType);
        return this.m_sysType;
    }

    public boolean getFrameState() {
        try {
            CIMInstance cIMInstance = this.getCIMInstance();
            UnsignedInt8 unsignedInt8 = (UnsignedInt8)PIHscUtil.getCIMAttrValue(cIMInstance, "State");
            int n = unsignedInt8.intValue();
            if (250 == n || 253 == n || 254 == n) {
                this.debug("getFrameState().state=" + n + " incompatible or connectionless or incomplete ");
                return false;
            }
            return true;
        }
        catch (HSCException hSCException) {
            this.debug("Unable to get CIM instance");
            hSCException.printStackTrace();
            return false;
        }
    }

    public Hashtable setPassword(short s, String string, String string2) {
        Hashtable<String, UnsignedInt16> hashtable = new Hashtable<String, UnsignedInt16>();
        UnsignedInt8 unsignedInt8 = new UnsignedInt8(s);
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        CIMValue cIMValue = new CIMValue((Object)unsignedInt8);
        vector.addElement(new CIMProperty(MOF_PASSWORD_TO_UPDATE, cIMValue));
        cIMValue = new CIMValue((Object)string);
        vector.addElement(new CIMProperty(MOF_CURRENT_PASSWORD, cIMValue));
        cIMValue = new CIMValue((Object)string2);
        vector.addElement(new CIMProperty(MOF_NEW_PASSWORD, cIMValue));
        try {
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_METHOD_SET_PASSWORD, vector, vector2);
            UnsignedInt16 unsignedInt16 = (UnsignedInt16)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
            hashtable.put("returnCode", unsignedInt16);
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
        }
        return hashtable;
    }

    public Hashtable platformPassword(String string) {
        Hashtable<String, UnsignedInt16> hashtable = new Hashtable<String, UnsignedInt16>();
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        CIMValue cIMValue = new CIMValue((Object)string);
        vector.addElement(new CIMProperty(MOF_PASSWORD, cIMValue));
        try {
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_METHOD_PLATFORM_PASSWORD, vector, vector2);
            UnsignedInt16 unsignedInt16 = (UnsignedInt16)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
            hashtable.put("returnCode", unsignedInt16);
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
        }
        return hashtable;
    }

    public String getDump(String string, String string2) throws PIHscClientException {
        boolean bl = true;
        String string3 = "";
        CIMValue cIMValue = null;
        try {
            Vector<CIMProperty> vector = new Vector<CIMProperty>();
            cIMValue = new CIMValue((Object)string, new CIMDataType(9));
            vector.addElement(new CIMProperty(MOF_DUMP_TYPE, cIMValue));
            cIMValue = new CIMValue((Object)string2, new CIMDataType(9));
            vector.addElement(new CIMProperty(MOF_DUMP_SIDE, cIMValue));
            Vector vector2 = new Vector();
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "ReadDump", vector, vector2);
            CIMProperty cIMProperty = (CIMProperty)vector2.elementAt(0);
            string3 = (String)cIMProperty.getValue().getValue();
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("0604", "HSCCIMExceptionBundle", "0604", null, cIMException);
            }
            throw pIHscClientException;
        }
        return string3;
    }

    public String[] queryDump(String string) throws PIHscClientException {
        int n = 0;
        Vector vector = null;
        String[] stringArray = new String[4];
        try {
            Vector<CIMProperty> vector2 = new Vector<CIMProperty>();
            CIMValue cIMValue = new CIMValue((Object)string, new CIMDataType(9));
            vector2.addElement(new CIMProperty(MOF_DUMP_SIDE, cIMValue));
            Vector vector3 = new Vector();
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "QueryDump", vector2, vector3);
            CIMProperty cIMProperty = (CIMProperty)vector3.elementAt(0);
            n = ((UnsignedInt32)cIMProperty.getValue().getValue()).intValue();
            this.debug("no : " + n);
            CIMProperty cIMProperty2 = (CIMProperty)vector3.elementAt(1);
            CIMValue cIMValue2 = cIMProperty2.getValue();
            vector = (Vector)cIMValue2.getValue();
            this.debug("types : " + vector);
            stringArray[0] = "" + n;
            stringArray[1] = (String)vector.get(0);
            stringArray[2] = (String)vector.get(1);
            stringArray[3] = (String)vector.get(2);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("0604", "HSCCIMExceptionBundle", "0604", null, cIMException);
            }
            throw pIHscClientException;
        }
        return stringArray;
    }

    public void initializeDump(String string) throws PIHscClientException {
        boolean bl = true;
        try {
            Vector<CIMProperty> vector = new Vector<CIMProperty>();
            Vector vector2 = new Vector();
            CIMValue cIMValue = new CIMValue((Object)string, new CIMDataType(9));
            vector.addElement(new CIMProperty(MOF_DUMP_SIDE, cIMValue));
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "InitializeDump", vector, vector2);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("0605", "HSCCIMExceptionBundle", "0605", null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public void initializeSPDump(String string) throws PIHscClientException {
        boolean bl = true;
        try {
            Vector<CIMProperty> vector = new Vector<CIMProperty>();
            Vector vector2 = new Vector();
            CIMValue cIMValue = new CIMValue((Object)string, new CIMDataType(9));
            vector.addElement(new CIMProperty(MOF_DUMP_SIDE, cIMValue));
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "InitializeSPDump", vector, vector2);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("0605", "HSCCIMExceptionBundle", "0605", null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public void rebootServiceProcessor(String string) throws PIHscClientException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            System.out.println("Calling CIM Method to perform reboot service processor");
            vector.add(new CIMProperty(MOF_FSP_TARGET, new CIMValue((Object)string)));
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_METHOD_REBOOTSP, vector, vector2);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public void codeUpdateComplete(String string, short s) throws PIHscClientException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            System.out.println("Calling CIM Method to perform code update complete");
            vector.add(new CIMProperty(MOF_FSP_TARGET, new CIMValue((Object)string)));
            vector.add(new CIMProperty(MOF_COMPLETION_TYPE, new CIMValue((Object)new UnsignedInt8(s))));
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_METHOD_CODEUPDATECOMPLETE, vector, vector2);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public void commitCodeUpdate(String string, short s) throws PIHscClientException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            System.out.println("Calling CIM Method to perform commit code update");
            vector.add(new CIMProperty(MOF_FSP_TARGET, new CIMValue((Object)string)));
            vector.add(new CIMProperty(MOF_COMMIT_TYPE, new CIMValue((Object)new UnsignedInt8(s))));
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_METHOD_COMMITCODEUPDATE, vector, vector2);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public void setCodeUpdateOwner(String string, short s) throws PIHscClientException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            System.out.println("Calling CIM Method to perform the set codeupdate owner");
            vector.add(new CIMProperty(MOF_FSP_TARGET, new CIMValue((Object)string)));
            vector.add(new CIMProperty(MOF_CODE_UPDATE_OWNER, new CIMValue((Object)new UnsignedInt8(s))));
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_METHOD_SETCODEUPDATEOWNER, vector, vector2);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public Vector getCodeUpdateStatus(String string) throws PIHscClientException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            System.out.println("Calling CIM Method to perform the get codeupdate status");
            vector.add(new CIMProperty(MOF_FSP_TARGET, new CIMValue((Object)string)));
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_METHOD_GETCODEUPDATEOWNER, vector, vector2);
            return vector2;
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public void startCodeUpdate(String string, short s, int n) throws PIHscClientException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            System.out.println("Calling CIM Method to perform Start Code Update process");
            vector.addElement(new CIMProperty(MOF_FSP_TARGET, new CIMValue((Object)string)));
            vector.addElement(new CIMProperty(MOF_FIRMWARE_UPDATE_SIDE, new CIMValue((Object)new UnsignedInt8(s))));
            vector.addElement(new CIMProperty(MOF_FIRMWARE_COMPONENT, new CIMValue((Object)new UnsignedInt16(n))));
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_METHOD_STARTCODEUPDATE, vector, vector2);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public void deleteLID(String string, Vector vector) throws PIHscClientException {
        Vector<CIMProperty> vector2 = new Vector<CIMProperty>();
        Vector vector3 = new Vector();
        try {
            System.out.println("Calling CIM Method to perform Delete LID");
            vector2.addElement(new CIMProperty(MOF_FSP_TARGET, new CIMValue((Object)string)));
            vector2.addElement(new CIMProperty(MOF_LID_NUMBER, new CIMValue(vector, new CIMDataType(25))));
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_METHOD_DELETELID, vector2, vector3);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public void readLID(String string, Vector vector, Vector vector2) throws PIHscClientException {
        Vector<CIMProperty> vector3 = new Vector<CIMProperty>();
        Vector vector4 = new Vector();
        try {
            System.out.println("Calling CIM Method to read LIDS");
            vector3.addElement(new CIMProperty(MOF_FSP_TARGET, new CIMValue((Object)string)));
            vector3.addElement(new CIMProperty(MOF_LID_NUMBER, new CIMValue(vector, new CIMDataType(25))));
            vector3.addElement(new CIMProperty(MOF_READ_LID_FILENAME, new CIMValue(vector2, new CIMDataType(29))));
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_METHOD_READLID, vector3, vector4);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public void readLIDPartial(String string, Vector vector, Vector vector2, Vector vector3, Vector vector4) throws PIHscClientException {
        Vector<CIMProperty> vector5 = new Vector<CIMProperty>();
        Vector vector6 = new Vector();
        try {
            System.out.println("Calling CIM Method to read LIDS partial");
            vector5.addElement(new CIMProperty(MOF_FSP_TARGET, new CIMValue((Object)string)));
            vector5.addElement(new CIMProperty(MOF_LID_NUMBER, new CIMValue(vector, new CIMDataType(25))));
            vector5.addElement(new CIMProperty(MOF_READ_LID_FILENAME, new CIMValue(vector2, new CIMDataType(29))));
            vector5.addElement(new CIMProperty(MOF_LID_OFFSET, new CIMValue(vector3, new CIMDataType(25))));
            vector5.addElement(new CIMProperty(MOF_LENGTH_TO_READ, new CIMValue(vector4, new CIMDataType(25))));
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_METHOD_READLID_PARTIAL, vector5, vector6);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public void readSpecialLID(String string, Vector vector, Vector vector2, Vector vector3, Vector vector4, Vector vector5) throws PIHscClientException {
        Vector<CIMProperty> vector6 = new Vector<CIMProperty>();
        Vector vector7 = new Vector();
        try {
            System.out.println("Calling CIM Method to read Special LIDS ");
            vector6.addElement(new CIMProperty(MOF_FSP_TARGET, new CIMValue((Object)string)));
            vector6.addElement(new CIMProperty(MOF_SPECIAL_LID, new CIMValue(vector, new CIMDataType(23))));
            vector6.addElement(new CIMProperty(MOF_FIRMWARE_UPDATE_SIDE, new CIMValue(vector2, new CIMDataType(21))));
            vector6.addElement(new CIMProperty(MOF_READ_LID_FILENAME, new CIMValue(vector3, new CIMDataType(29))));
            vector6.addElement(new CIMProperty(MOF_LID_OFFSET, new CIMValue(vector4, new CIMDataType(25))));
            vector6.addElement(new CIMProperty(MOF_LENGTH_TO_READ, new CIMValue(vector5, new CIMDataType(25))));
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_METHOD_READLID_SPECIAL, vector6, vector7);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public void writeLID(String string, Vector vector, Vector vector2) throws PIHscClientException {
        Vector<CIMProperty> vector3 = new Vector<CIMProperty>();
        Vector vector4 = new Vector();
        try {
            System.out.println("Calling CIM Method to perform Write LID process");
            vector3.addElement(new CIMProperty(MOF_FSP_TARGET, new CIMValue((Object)string)));
            vector3.addElement(new CIMProperty(MOF_LID_NUMBER, new CIMValue(vector, new CIMDataType(25))));
            vector3.addElement(new CIMProperty(MOF_LID_FILENAME, new CIMValue(vector2, new CIMDataType(29))));
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_METHOD_WRITELID, vector3, vector4);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }

    public void writePartialLID(String string, Vector vector, Vector vector2, Vector vector3, Vector vector4) throws PIHscClientException {
        Vector<CIMProperty> vector5 = new Vector<CIMProperty>();
        Vector vector6 = new Vector();
        try {
            System.out.println("Calling CIM Method to perform Write partial LIDs ");
            vector5.addElement(new CIMProperty(MOF_FSP_TARGET, new CIMValue((Object)string)));
            vector5.addElement(new CIMProperty(MOF_FIRMWARE_UPDATE_SIDE, new CIMValue(vector, new CIMDataType(21))));
            vector5.addElement(new CIMProperty(MOF_LID_NUMBER, new CIMValue(vector2, new CIMDataType(25))));
            vector5.addElement(new CIMProperty(MOF_LID_FILENAME, new CIMValue(vector4, new CIMDataType(29))));
            vector5.addElement(new CIMProperty(MOF_LID_OFFSET, new CIMValue(vector3, new CIMDataType(25))));
            PIHscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_METHOD_WRITELID_PARTIAL, vector5, vector6);
        }
        catch (CIMException cIMException) {
            PIHscClientException pIHscClientException = PIHscExceptionUtils.convert(cIMException);
            if (pIHscClientException == null) {
                pIHscClientException = new PIHscClientException("7000", "CIMExceptionBundle", cIMException.getID(), null, cIMException);
            }
            throw pIHscClientException;
        }
    }
}

